-- ============================================================
-- DBAOps: Agent Lifecycle Management Schema
-- ============================================================
IF NOT EXISTS (SELECT 1 FROM sys.schemas WHERE name = 'agent')
    EXEC('CREATE SCHEMA agent');
GO

-- Agent Packages (for distribution)
CREATE TABLE agent.Packages (
    PackageID INT IDENTITY(1,1) PRIMARY KEY,
    PackageVersion NVARCHAR(20) NOT NULL,
    Platform NVARCHAR(50) NOT NULL, -- Windows, Linux, Kubernetes
    Architecture NVARCHAR(20), -- x64, ARM64
    PackageType NVARCHAR(20), -- MSI, DEB, RPM, Helm, ZIP
    Channel NVARCHAR(20) DEFAULT 'Stable', -- Stable, Preview, Beta
    DownloadURL NVARCHAR(500),
    FileSize BIGINT,
    SHA256Hash NVARCHAR(64),
    ReleaseDate DATETIME2,
    ReleaseNotes NVARCHAR(MAX),
    MinimumOSVersion NVARCHAR(50),
    IsLatest BIT DEFAULT 0,
    IsDeprecated BIT DEFAULT 0
);

-- Agent Deployment Tasks
CREATE TABLE agent.DeploymentTasks (
    TaskID INT IDENTITY(1,1) PRIMARY KEY,
    TaskType NVARCHAR(20), -- Install, Upgrade, Rollback, Uninstall, Repair
    TargetHosts NVARCHAR(MAX), -- JSON array of hostnames
    PackageID INT FOREIGN KEY REFERENCES agent.Packages(PackageID),
    DeploymentMethod NVARCHAR(50), -- SCCM, Intune, GPO, Tanium, Ansible, Manual
    ScheduledTime DATETIME2,
    StartedAt DATETIME2,
    CompletedAt DATETIME2,
    Status NVARCHAR(20) DEFAULT 'Pending', -- Pending, InProgress, Completed, Failed, Cancelled
    TotalHosts INT,
    SuccessCount INT DEFAULT 0,
    FailedCount INT DEFAULT 0,
    CreatedBy NVARCHAR(128),
    CreatedAt DATETIME2 DEFAULT GETDATE()
);

-- Agent Health Status
CREATE TABLE agent.HealthStatus (
    HealthID BIGINT IDENTITY(1,1) PRIMARY KEY,
    AgentID UNIQUEIDENTIFIER,
    HostName NVARCHAR(256),
    ReportedAt DATETIME2 DEFAULT GETDATE(),
    
    -- Health Metrics
    CPUUsagePercent DECIMAL(5,2),
    MemoryUsageMB INT,
    DiskUsageMB INT,
    QueueDepth INT,
    ProcessingRate DECIMAL(10,2),
    
    -- Service Status
    ServiceStatus NVARCHAR(20), -- Running, Stopped, Starting, Stopping
    UptimeSeconds BIGINT,
    LastRestart DATETIME2,
    RestartCount INT,
    
    -- Connectivity
    LastServerContact DATETIME2,
    ConnectionLatencyMs INT,
    DataSentBytes BIGINT,
    DataReceivedBytes BIGINT,
    
    -- Errors
    ErrorCount INT DEFAULT 0,
    LastError NVARCHAR(MAX),
    
    INDEX IX_AgentHealth_Time NONCLUSTERED (ReportedAt DESC)
);

-- Agent Self-Heal Actions
CREATE TABLE agent.SelfHealActions (
    ActionID INT IDENTITY(1,1) PRIMARY KEY,
    AgentID UNIQUEIDENTIFIER,
    ActionType NVARCHAR(50), -- ServiceRestart, QueueDrain, CacheClear, ConfigReload, FullRestart
    TriggerCondition NVARCHAR(200),
    ActionTimestamp DATETIME2 DEFAULT GETDATE(),
    ActionResult NVARCHAR(20), -- Success, Failed
    Details NVARCHAR(MAX)
);

PRINT '✅ Agent Lifecycle Management Schema Created';
